function V = HW4PlaceNeedleVF(Fins,Fhn,r,Kn,Ks )
%Virtual fixture for placing a needle on a target
%
% Fins  = local coord system at insertion point
% Fhn   = grasp Fn = Fh*Fhn, where Fh = hand coordinate system
% r     = radius of needle
% Kn    = stiffness for aligning the needle
% Ks    = stiffness resisting penetration
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

pht = Fhn*vct3(0,0,r);          % tip in hand coords
Fc  = Frame(Fins.R,Fins.p-pt);  % where hand needs to be to insert needle tip
z3  = [0,0,0];
V   = HW4VirtualFixture(Fc,-[Kn,Kn,Kn],[0,0,-Ks],z3,z3,z3,z3,RotMX.eye(),z3,z3,z3,z3);
end

